module.exports = function (grunt) {

	grunt.config('copy', {
		dev: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'**/*.js',
					'**/*.html',
					'src/**/*.css',
					'favicon.ico',
					'assets/pdfs/*',
					'!index*.html',
					'assets/html/dev/index.html',
					'assets/fonts/**/*',
					'!assets/fonts/**/*.html',
					'!assets/fonts/**/*.css',
					'!**/*_spec.js',
					'libs/**/*.js',
					'libs/angular-busy/css/angular-busy.css',
					'libs/angular-snap/css/angular-snap.css',
					'assets/css/angular-snap.css',
					'assets/fonts/agilex/styles.css',
					'libs/angular-busy/images/ajax-loader.gif'
				]
			}, {
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>/assets/fonts',
				src: [
					'libs/sass-bootstrap/fonts/*extended*.*'
				],
				flatten: true
			}]
		},
		dist: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'favicon.ico',
					'assets/pdfs/*',
					'!index*.html',
					'assets/html/prod/index.html',
					'src/**/*.css',
					'src/templates.js',
					'assets/fonts/**/*',
					'!assets/fonts/**/*.html',
					'!assets/fonts/**/*.css',
					'libs/angular-busy/css/angular-busy.css',
					'libs/angular-snap/css/angular-snap.css',
					'assets/css/angular-snap.css',
					'assets/fonts/agilex/styles.css',
					'libs/angular-busy/images/ajax-loader.gif'
				]
			}, {
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>/assets/fonts',
				src: [
					'libs/sass-bootstrap/fonts/*extended*.*'
				],
				flatten: true
			}]
		}
	});

	grunt.loadNpmTasks('grunt-contrib-copy');

};